package ru.yandex.search.document.mail;

import java.util.Map;

import org.apache.james.mime4j.stream.Field;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.function.FalsePredicate;

public class FirstlineMailMetaInfo extends MdbMailMetaInfo {
    private String firstline = null;

    public FirstlineMailMetaInfo() {
        super(-1, -1, FalsePredicate.INSTANCE);
    }

    @Override
    public void add(final String name, final String body, final Field field) {
        if (name.equals(X_YANDEX_META_FIRSTLINE)) {
            String firstline = decodeBase64(body);
            if (!firstline.isEmpty()) {
                firstline(firstline);
            }
        }
        super.add(name, body, field);
    }

    @Override
    public Map<String, String> toFastDocMap() {
        Map<String, String> map = super.toFastDocMap();
        if (firstline != null && !firstline.isEmpty()) {
            map.put(MailIndexFields.PURE_BODY, firstline);
        }
        return map;
    }

    public void firstline(final String firstline) {
        this.firstline = firstline;
    }

    public String firstline() {
        return firstline;
    }
}

