package ru.yandex.search.document.mail;

import java.util.Arrays;

public class HidCounter {
    private static final int CAPACITY = 4;

    private final StringBuilder sb = new StringBuilder();
    private int[] hid = new int[CAPACITY];
    private int size = 1;
    private boolean popped = false;
    private int partsCount = 0;

    public HidCounter() {
        hid[0] = 1;
    }

    public int partsCount() {
        return partsCount;
    }

    public void incrementPartsCount() {
        ++partsCount;
    }

    public String hid() {
        sb.setLength(0);
        int size = depth();
        for (int i = 0; i < size; ++i) {
            sb.append(hid[i]);
            sb.append('.');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public void createPart() {
        if (popped) {
            popped = false;
            ++hid[size - 1];
        } else {
            if (size == hid.length) {
                hid = Arrays.copyOf(hid, size << 1);
            }
            hid[size++] = 1;
        }
    }

    public void popPart() {
        if (popped) {
            --size;
        } else {
            popped = true;
        }
    }

    public int depth() {
        int depth = size;
        if (popped) {
            --depth;
        }
        return depth;
    }
}

