package ru.yandex.search.document.mail;

import java.util.List;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.xpath.PathComponent;

public class JsonFirstlineMailMetaHandler extends JsonMdbMailMetaHandler {
    private final FirstlineMailMetaInfo meta;

    public JsonFirstlineMailMetaHandler(final FirstlineMailMetaInfo meta) {
        super(meta);
        this.meta = meta;
    }

    @Override
    public void handle(final List<PathComponent> path, final Object value)
        throws JsonException
    {
        if (value != null && path.size() == 1
            && MailMetaInfo.FIRSTLINE.equals(path.get(0).name()))
        {
            String firstline = value.toString();
            if (!firstline.isEmpty()) {
                meta.firstline(firstline);
            }
        }
        super.handle(path, value);
    }

    @Override
    public void handle(final JsonMap envelope) throws JsonException {
        super.handle(envelope);
        String firstline = envelope.getString(MailMetaInfo.FIRSTLINE, null);
        if (firstline != null && !firstline.isEmpty()) {
            meta.firstline(firstline);
        }
    }
}

