package ru.yandex.search.document.mail;

import java.util.List;

import ru.yandex.json.parser.JsonException;
import ru.yandex.json.xpath.PathComponent;

public class JsonMdbMailMetaHandler extends JsonMailMetaHandler {
    private final MdbMailMetaInfo meta;

    public JsonMdbMailMetaHandler(final MdbMailMetaInfo meta) {
        super(meta);
        this.meta = meta;
    }

    @Override
    public void handle(final List<PathComponent> path, final Object value)
        throws JsonException
    {
        if (value != null && path.size() == 1
            && MailMetaInfo.MDB.equals(path.get(0).name()))
        {
            String mdb = value.toString();
            if (!mdb.isEmpty()) {
                meta.mdb(mdb);
            }
        }
        super.handle(path, value);
    }
}

