package ru.yandex.search.document.mail;

import java.net.InetAddress;
import java.util.function.Predicate;

import org.apache.james.mime4j.stream.Field;

public class MdbMailMetaInfo extends MailMetaInfo {
    protected String mdb = null;

    public MdbMailMetaInfo(
        final int headersLengthLimit,
        final int headerLengthLimit,
        final Predicate<? super InetAddress> yandexNets)
    {
        super(headersLengthLimit, headerLengthLimit, yandexNets);
    }

    @Override
    public void add(final String name, final String body, final Field field) {
        if (name.equals(X_YANDEX_MDB) && body != null && !body.isEmpty()) {
            mdb(body);
        }
        super.add(name, body, field);
    }

    public void mdb(final String mdb) {
        this.mdb = mdb;
    }
}

