package ru.yandex.search.document.mail;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public class OnlineMailMetaInfo extends MdbMailMetaInfo {
    public OnlineMailMetaInfo(
        final int headersLengthLimit,
        final int headerLengthLimit,
        final Predicate<? super InetAddress> yandexNets)
    {
        super(headersLengthLimit, headerLengthLimit, yandexNets);
    }

    @Override
    public Map<String, String> fields() {
        if (mdb == null) {
            return super.fields();
        } else {
            Map<String, String> result = new HashMap<>(super.fields());
            result.put(MDB, mdb);
            return result;
        }
    }
}

