package ru.yandex.search.document.mail;

import java.io.IOException;
import java.io.InputStream;

import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeTokenStream;

import ru.yandex.mail.mime.DefaultMimeConfig;
import ru.yandex.mail.mime.OverwritingBodyDescriptorBuilder;
import ru.yandex.mail.mime.Utf8FieldBuilder;

public class SafeMimeTokenStream extends MimeTokenStream {
    public SafeMimeTokenStream() {
        super(
            DefaultMimeConfig.INSTANCE,
            null,
            new Utf8FieldBuilder(),
            new OverwritingBodyDescriptorBuilder());
    }

    public static SafeMimeTokenStream parseMeta(
        final InputStream in,
        final MailMetaInfo meta)
        throws IOException, MimeException
    {
        SafeMimeTokenStream stream = new SafeMimeTokenStream();
        stream.parse(in);
        if (stream.getState() == EntityState.T_START_MESSAGE
            && stream.next() == EntityState.T_START_HEADER)
        {
            while (stream.next() == EntityState.T_FIELD) {
                meta.add(stream.getField());
            }
            if (stream.getState() == EntityState.T_END_HEADER) {
                stream.next();
            } else {
                throw new MimeException("Bad state: " + stream.getState());
            }
        }
        return stream;
    }

    @Override
    public void parse(final InputStream in) {
        if (in != null) {
            super.parse(in);
        }
    }
}

