#!/bin/bash
set -xo pipefail

export TVM_API_HOST=https://tvm-api.yandex.net
export REVISION_FILE_PATH=revision_mail.txt
export SEARCHMAP_PATH=searchmap_mail.txt
export APE_TVM_CLIENT_ID=200

export LIMIT_THREADS="True"

case "$NANNY_SERVICE_ID" in
    *_test)
        export TVM_CLIENT_ID=186
        export BLACKBOX_CLIENT_ID=224
        export CORP_BLACKBOX_CLIENT_ID=225
        export FILTERSEARCH_CLIENT_ID=2000501
        export CORP_FILTERSEARCH_CLIENT_ID=2000501
        export BLACKBOX_HOST="http://pass-test.yandex.ru"
        export CORP_BLACKBOX_HOST=$BLACKBOX_HOST
        export BACKEND_PRODUCER_HOST="salo-producer-test.n.yandex-team.ru:80"
        export PRODUCER_HOST="salo-producer-test.n.yandex-team.ru:80"
        export FILTER_SEARCH_HOST="http://meta-test.mail.yandex.net:80"
        export BACKEND_FILTER_SEARCH_HOST=$FILTER_SEARCH_HOST
        export CORP_FILTER_SEARCH_HOST=$FILTER_SEARCH_HOST
        export MOP_HOST="http://mail-search-mop-test.pers.yandex.net"
        export MOP_TEST_HOST="http://mail-search-mop-test.pers.yandex.net"
        export MOPS_HOST="https://mops-test.mail.yandex.net"
        export MOPS_TVM_ID=2000577
        export PRODUCER_LIST="sas1-1180.search.yandex.net:17904,sas1-6433.search.yandex.net:17904,man1-5128.search.yandex.net:17904,vla2-0479.search.yandex.net:17904"
        export LOGROTATE_DAYS=2
        export MAGE_PARAMS=""
        export MAGE_URI=/api/v2.0/mailqa/getmap
        export BP_MAGE_URI=$MAGE_URI
        export CORP_MAGE_URI=$MAGE_URI
        export TVM_TIKAITE_ID=200
        export TVM_UNISTORAGE_ID=2000272
        export TIKAITE_SRW_HOST=tikaite.tst.ape.yandex.net
        ;;
    mail_msearch_proxy*|mail_msearch_proxy_qa|*_prestable|*_prod|*_prod_*|*-prod|mail_sosearch_proxy*)
        export BLACKBOX_CLIENT_ID=222
        export CORP_BLACKBOX_CLIENT_ID=223
        export FILTERSEARCH_CLIENT_ID=2000499
        export CORP_FILTERSEARCH_CLIENT_ID=2000500
        export TVM_CLIENT_ID=2000031
        export PRODUCER_LIST="man2-6675.search.yandex.net:8081,man2-6788.search.yandex.net:8081,man2-7002.search.yandex.net:8081,myt1-1487.search.yandex.net:8081,myt1-1496.search.yandex.net:8081,myt1-1821.search.yandex.net:8081,sas1-9184.search.yandex.net:8081,sas1-9224.search.yandex.net:8081,sas1-9317.search.yandex.net:8081"
        export WEBATTACH_HOST="webattach.mail.yandex.net"
        export CORP_WEBATTACH_HOST="webattachcorp.mail.yandex.net"
        export BLACKBOX_HOST="http://blackbox-mail.yandex.net"
        export CORP_BLACKBOX_HOST="http://blackbox.yandex-team.ru"
        export BACKEND_PRODUCER_HOST=salo-producer.mail.yandex.net:80
        export PRODUCER_HOST=salo-producer.search.yandex.net:8081
        export FILTER_SEARCH_HOST="http://meta-qloud.mail.yandex.net:80"
        export BACKEND_FILTER_SEARCH_HOST="http://meta-search.mail.yandex.net:80"
        export CORP_FILTER_SEARCH_HOST="http://metacorp-qloud.mail.yandex.net:80"
        export MOP_HOST="http://mail-search-mop-prod.pers.yandex.net"
        export MOP_PROD_SCOPE="mail_bp"
        export MOP_CORP_SCOPE="mail_corp"
        export MOP_TEST_HOST="http://mail-search-mop-test.pers.yandex.net"
        export MOPS_HOST="https://mops.mail.yandex.net"
        export MOPS_TVM_ID=2000571
        export BP_MAGE_URI=/api/v1.0/mail/getmap
        export CORP_MAGE_URI=/api/v2.0/mailcorp/getmap
        export MAGE_PARAMS="&pformat=zkmtn"
        export PRODUCER_GROUP=MAIL_SALO_PRODUCER 
        export LOGROTATE_DAYS=7
        # watchdog settings
        export WATCHDOG_UID=203889311
        export WATCHDOG_MAIL_ID=156218612074414099
        export TVM_TIKAITE_ID=200
        export TVM_UNISTORAGE_ID=2000273
        export TIKAITE_SRW_HOST=tikaite.ape.yandex.net
        ;;
esac

