package ru.yandex.mail.search;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.prefix.LongPrefix;

public final class MailSearchParams {
    public static final String UID = "uid";
    public static final String MDB = "mdb";
    public static final String MID = "mid";
    public static final String STID = "stid";
    public static final String SERVICE = "service";
    public static final String PREFIX = "prefix";
    public static final String REQUEST = "request";

    private MailSearchParams() {
    }

    public static User changeLogUser(final long uid) {
        return new User(changeLogService(uid), new LongPrefix(uid));
    }

    public static String offlineService(final long uid) {
        if (BlackboxUserinfo.corp(uid)) {
            return MailSearchDefaults.CORP_CHANGE_LOG;
        }

        return MailSearchDefaults.BP_CHANGE_LOG;
    }

    public static String changeLogService(final long uid) {
        if (BlackboxUserinfo.corp(uid)) {
            return MailSearchDefaults.CORP_CHANGE_LOG;
        }

        return MailSearchDefaults.BP_CHANGE_LOG;
    }
}
