package ru.yandex.mail.search.subscriptions;

import ru.yandex.parser.email.MailAliases;

public class SubscriptionUtils {
    private static final int URL_PREFIX_SIZE = 20;

    public static String urlByNormalizedEmail(
        final long uid,
        final String normalizedEmail)
    {
        StringBuilder sb = new StringBuilder(
            normalizedEmail.length() + URL_PREFIX_SIZE);
        sb.append("subs_");
        sb.append(uid);
        sb.append('_');
        sb.append(normalizedEmail);
        return sb.toString();
    }

    public static String urlByNormalized(
        final long uid,
        final String normalizedEmail)
    {
        StringBuilder sb = new StringBuilder(
            normalizedEmail.length() + URL_PREFIX_SIZE);
        sb.append("subs_");
        sb.append(uid);
        sb.append('_');
        sb.append(normalizedEmail);
        return sb.toString();
    }

    public static String normalizeEmailForSubs(final String emailRaw) {
        String email = MailAliases.INSTANCE.normalizeEmail(emailRaw);
        int atIndex = email.indexOf('@');
        if (atIndex <= 0) {
            return email;
        }

        String normalized = email;
        int plusIndex = email.indexOf('+');
        if (plusIndex > 0 && plusIndex < atIndex) {
            normalized =
                email.substring(0, plusIndex) + email.substring(atIndex);
        }

        return normalized;
    }
}
