package ru.yandex.mail.search.subscriptions;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;

public class SubscriptionsConstants {
    public static final String SUBSCRIPTIONS_SERVICE =
        System.getenv().getOrDefault("SUBSCRIPTIONS_QUEUE", "subscriptions_prod_1");
    public static final Set<String> TYPES =
        Collections.unmodifiableSet(new LinkedHashSet<>(Arrays.asList("13")));
    public static final Set<String> OPT_IN_TYPES =
        Collections.unmodifiableSet(new LinkedHashSet<>(Arrays.asList("13", "100")));
    public static final CollectionParser<String, Set<String>, Exception> BACKEND_RESP_TYPES_PARSER =
        new CollectionParser<>(
            NonEmptyValidator.TRIMMED,
            LinkedHashSet::new,
            '\n');
}
