package ru.yandex.search.migrations_worker;

import ru.yandex.logger.BackendAccessLoggerConfigDefaults;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.logger.ProxyAccessLoggerConfigDefaults;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;
import ru.yandex.msearch.proxy.config.AsyncHttpServerBaseConfigBuilder;
import ru.yandex.msearch.proxy.config.ImmutableAsyncHttpServerBaseConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.msal.pool.AddressPgConfigBuilder;
import ru.yandex.search.msal.pool.ImmutableAddressPgConfig;

public class MigrationsWorkerConfig extends ImmutableAsyncHttpServerBaseConfig {
    private final ImmutableAddressPgConfig pgPoolConfig;

    public MigrationsWorkerConfig(IniConfig config) throws ConfigException {
        super(createConfig(config));
        pgPoolConfig = new AddressPgConfigBuilder(config.section("database.postgresql")).build();
    }

    private static ImmutableAsyncHttpServerBaseConfig createConfig(final IniConfig ini)
        throws ConfigException
    {
        AsyncHttpServerBaseConfigBuilder config = new AsyncHttpServerBaseConfigBuilder(ini);
        LoggerConfigBuilder loggerConfig =
            new LoggerConfigBuilder(BackendAccessLoggerConfigDefaults.INSTANCE);
        loggerConfig.single().logFormat(
            BackendAccessLoggerConfigDefaults.INSTANCE
                .logFormat()
                + ProxyAccessLoggerConfigDefaults.LOG_FORMAT_SUFFIX
                + " %{"
                + SearchProxyAccessLoggerConfigDefaults.HITS_COUNT
                + '}');
        config.searchMapConfig(null);
        return config.build();
    }

    public ImmutableAddressPgConfig pgPoolConfig() {
        return pgPoolConfig;
    }
}

