package ru.yandex.search.migrations_worker;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import ru.yandex.msearch.proxy.AsyncHttpServerBase;
import ru.yandex.msearch.proxy.api.async.mail.subscriptions.update.dao.MigrationsTasksPostgresDao;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.msal.pool.DBConnectionPool;

public class MigrationsWorkerService
    extends AsyncHttpServerBase<MigrationsWorkerConfig>
{
    private final MigrationsWorkerConfig typedConfig;

    private final ExecutorService utilityExecutor;

    private final MigrationsTasksPostgresDao tasksDao;
    private final TasksPlanner tasksPlanner;

    public MigrationsWorkerService(MigrationsWorkerConfig config) throws Exception {
        super(config);
        this.typedConfig = config;
        this.utilityExecutor = Executors.newSingleThreadExecutor();
        DBConnectionPool connectionPool = new DBConnectionPool(
                config.pgPoolConfig().url(),
                config.pgPoolConfig(),
                logger()
        );
        this.tasksDao = new MigrationsTasksPostgresDao(connectionPool, logger());
        this.tasksPlanner = new TasksPlanner(
                this,
                new MigrationsWorkerLock(this),
                tasksDao
        );

        registerStater(new MigrationsWorkerStater(tasksDao, tasksPlanner));
    }

    @Override
    public void start() throws IOException {
        super.start();
        utilityExecutor.submit(tasksPlanner);
        logger().info("started");
    }

    @Override
    public MigrationsWorkerConfig config() {
        return typedConfig;
    }

    public static void main(String... args)
        throws ConfigException, IOException
    {
        main(new MigrationsWorkerServiceFactory(), args);
    }
}
