package ru.yandex.search.migrations_worker;

import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import ru.yandex.http.util.server.HttpServer;
import ru.yandex.http.util.server.HttpServerFactory;
import ru.yandex.parser.config.IniConfig;

public class MigrationsWorkerServiceFactory
    implements HttpServerFactory
        <MigrationsWorkerConfig, HttpAsyncRequestHandler<?>>
{
    @Override
    public String name() {
        return MigrationsWorkerService.class.getName();
    }

    @Override
    public HttpServer<MigrationsWorkerConfig, HttpAsyncRequestHandler<?>>
        create(final IniConfig config)
    {
        try {
            return new MigrationsWorkerService(
                new MigrationsWorkerConfig(config));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
