package ru.yandex.search.migrations_worker;

import ru.yandex.logger.PrefixedLogger;

public abstract class SingleInstancePeriodicRunner implements Runnable {
    private static final long DELAY_MS = 500;
    private final MigrationsWorkerLock lock;
    protected final PrefixedLogger logger;

    protected SingleInstancePeriodicRunner(MigrationsWorkerLock lock, PrefixedLogger logger) {
        this.lock = lock;
        this.logger = logger;
    }

    @Override
    public void run() {
        logger.info("Running");
        while (!Thread.currentThread().isInterrupted()) {
            while (lock.tryLock() && tryToRun()) {}
            try {
                Thread.sleep(DELAY_MS);
            } catch (InterruptedException e) {
                // do nothing
            }
        }
        logger.info("Interrupted");
    }

    public boolean isRunning() {
        return lock.isLocked();
    }

    abstract boolean tryToRun();
}
