package ru.yandex.search.migrations_worker;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import ru.yandex.msearch.proxy.AsyncHttpServerBase;
import ru.yandex.msearch.proxy.api.async.mail.subscriptions.update.dao.MigrationsTasksPostgresDao;
import ru.yandex.msearch.proxy.api.async.mail.subscriptions.update.dao.pojo.MigrationTask;
import ru.yandex.msearch.proxy.api.async.mail.subscriptions.update.dao.pojo.MigrationTaskStatus;
import ru.yandex.msearch.proxy.config.ImmutableAsyncHttpServerBaseConfig;

public class TasksPlanner extends SingleInstancePeriodicRunner {
    private static final int THREADS = 10;

    private final AsyncHttpServerBase
        <? extends ImmutableAsyncHttpServerBaseConfig> service;

    private final MigrationsTasksPostgresDao tasksDao;
    private final ExecutorService executor;

    public TasksPlanner(
            AsyncHttpServerBase<? extends ImmutableAsyncHttpServerBaseConfig> service,
            MigrationsWorkerLock lock,
            MigrationsTasksPostgresDao tasksDao)
    {
        super(lock, service.logger().replacePrefix(TasksPlanner.class.getSimpleName()));
        this.service = service;
        this.tasksDao = tasksDao;
        this.executor = Executors.newFixedThreadPool(THREADS);
    }

    @Override
    protected boolean tryToRun() {
        logger.info("Fetching tasks");
        List<MigrationTask> tasks = tasksDao.findPendingTasks();
        logger.info("Fetched created tasks: " + tasks.size());
        for (int i = 0; i < tasks.size(); i++) {
            tasksDao.updateStatus(tasks.get(i), MigrationTaskStatus.RUNNING);
            executor.submit(new TaskRunner(service, tasksDao, tasks.get(i), logger));
        }
        logger.info("Deleting expired tasks...");
        tasksDao.deleteExpiredTasks();
        logger.info("Deleted");
        return !tasks.isEmpty();
    }
}
