#!/bin/bash
set -exo pipefail
source msal_config.sh
source classpath.sh

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8

APP_ARGS="-DBSCONFIG_IPORT=$BSCONFIG_IPORT
-DBSCONFIG_IHOST=$BSCONFIG_IHOST
-DBSCONFIG_INAME=$BSCONFIG_INAME
"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
GC_ARGS="-Xgcpolicy:gencon
-Xloa
-Xnoclassgc
-Xconcurrentbackground6
-Xconcurrentlevel8
-Xgcthreads8
-verbose:gc
-Xpartialcompactgc
-Xverbosegclog:/logs/gc#.log,10,10000"

MEM_ARGS="-Xmr16M -Xms4096M -Xmx4096M"

exec $BSCONFIG_IDIR/jdk/bin/java \
    -Djava.library.path=msal \
    -verbose:gc \
    $NET_ARGS $GC_ARGS $APP_ARGS \
    -DPORTO=1 \
    -cp $CLASSPATH \
    ru.yandex.search.msal.Server \
    $MSAL_CONFIG