#!/bin/bash
set -e

source msal_config.sh

ORG_ID=$1
DB_MODE=${2:-"read_write"}
SECRET_TYPE=${SECRET_TYPE:-"mail"}

SHARPEI_RESPONSE=$(curl -s "$SHARPEI_ORG_HOST/org_conninfo?org_id=$ORG_ID&mode=read_write" | jq .)
FIRST_DATABASE=$(echo $SHARPEI_RESPONSE | jq -r .databases[0].address.host)
echo "$SHARPEI_RESPONSE"
echo "CONNECTING TO $FIRST_DATABASE"

if [ "$SECRET_TYPE" == "ace" ]; then
  PGPASSWORD=$(cat collie_secret/aceventura | grep "$ENVIROMENT" | awk "{print \$2}") psql -h $FIRST_DATABASE -p 6432 -U aceventura -w maildb
else
  PGPASSFILE=secret/pgpass psql -h $FIRST_DATABASE -p 6432 -U msearch -w maildb
fi
