package ru.yandex.search.msal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.dbfields.OracleFields;
import ru.yandex.dbfields.PgFields;
import ru.yandex.http.server.sync.HttpSession;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeLongValidator;
import ru.yandex.parser.string.PositiveLongValidator;
import ru.yandex.search.msal.pool.DBConnectionPool;
import ru.yandex.search.msal.pool.StatementHolder;
import ru.yandex.search.msal.processors.ResultSetFieldProcessorFactory;
import ru.yandex.util.string.PrettyPrint;
import ru.yandex.util.string.StringUtils;

public abstract class AbstractOperationsQueueHandler
    extends AbstractReplicaHandler
{
    private static final long DEFAULT_LENGTH = 1000;

    private final String queryStart;
    private final String queryEnd;
    private final String tableName;

    protected AbstractOperationsQueueHandler(
        final String tableName,
        final String queryStart,
        final String queryEnd)
    {
        super(false);

        this.queryStart = queryStart;
        this.queryEnd = queryEnd;
        this.tableName = tableName;
    }

    protected String query(final String table) {
        return StringUtils.concat(queryStart, table, queryEnd);
    }

    @Override
    public void handlePgRequest(
        final HttpSession session,
        final DBConnectionPool connPool,
        final long uid)
        throws HttpException, SQLException
    {
        DumpParams params = new DumpParams(session);
        String table = this.tableName;

        String date = session.params().getString("date", null);
        if (date != null) {
            table += "_p" + date;
        }

        long operationId =
            session.params().get("op-id", NonNegativeLongValidator.INSTANCE);
        long length = session.params().get(
            "length",
            DEFAULT_LENGTH,
            PositiveLongValidator.INSTANCE);
        Map<String, String> staticFields = new HashMap<>(2 << 1);
        staticFields.put(
            PgFields.PGSHARD,
            session.params().get(
                PgFields.PGSHARD,
                NonEmptyValidator.INSTANCE));
        staticFields.put(
            OracleFields.SELECT_DATE,
            PrettyPrint.millisToSeconds(System.currentTimeMillis()));

        try (ConnectionHolder conn = new ConnectionHolder(
            connPool.getConnection(session.logger()));
             StatementHolder<PreparedStatement> stmt =
                 new StatementHolder<>(
                     conn.get().prepareStatement(
                         query(table))))
        {
            stmt.get().setLong(1, operationId);
            stmt.get().setLong(2, length);
            SearchQueueHandler.writeResultSet(
                params,
                conn,
                stmt,
                new ResultSetFieldProcessorFactory(staticFields));
        }
    }

    @Override
    public String toString() {
        return "Retrives batch of envelopes from operations_queue"
            + " or mail.change_log";
    }
}

