package ru.yandex.search.msal;

import java.io.Closeable;
import java.io.IOException;

public class AutoCloseableCleaner<T extends AutoCloseable>
    implements Closeable
{
    private final T value;
    private final Closeable parent;

    public AutoCloseableCleaner(final T value) {
        this(value, null);
    }

    public AutoCloseableCleaner(final T value, final Closeable parent) {
        this.value = value;
        this.parent = parent;
    }

    public T value() {
        return value;
    }

    public Closeable parent() {
        return parent;
    }

    @Override
    public void close() throws IOException {
        Exception e = null;
        try {
            value().close();
        } catch (Exception ex) {
            e = ex;
        }

        Closeable parent = parent();
        if (e == null) {
            if (parent != null) {
                parent.close();
            }
        } else {
            if (parent != null) {
                try {
                    parent.close();
                } catch (IOException ex) {
                    e.addSuppressed(ex);
                }
            }
            throw new IOException(e);
        }
    }
}

