package ru.yandex.search.msal;

import ru.yandex.collection.PatternMap;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.server.HttpProxyConfigBuilder;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.logger.BackendAccessLoggerConfigDefaults;
import ru.yandex.logger.LoggerConfigBuilder;
import ru.yandex.logger.LoggersConfigBuilder;
import ru.yandex.logger.ProxyAccessLoggerConfigDefaults;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.msal.pool.ImmutablePoolConfig;
import ru.yandex.search.msal.pool.PoolConfigBuilder;
import ru.yandex.stater.ImmutableStatersConfig;
import ru.yandex.stater.StatersConfigBuilder;
import ru.yandex.stater.StatersConfigDefaults;

public class Config extends ImmutableHttpProxyConfig {
    private final ImmutableHttpHostConfig sharpeiConfig;
    private final ImmutableHttpHostConfig orgSharpeiConfig;
    private final ImmutablePoolConfig pgPoolConfig;
    private final ImmutablePoolConfig aceVenturaPoolConfig;
    private final ImmutableStatersConfig orgSharpeiStaters;

    public Config(final IniConfig config) throws ConfigException {
        super(createConfig(config));
        sharpeiConfig =
            new HttpHostConfigBuilder(config.section("sharpei")).build();
        pgPoolConfig =
            new PoolConfigBuilder(
                config.section("database.postgresql"))
                .build();
        aceVenturaPoolConfig =
            new PoolConfigBuilder(
                config.section("database.aceventura"))
                .build();

        IniConfig orgSharpeiSection = config.sectionOrNull("sharpei-org");
        if (orgSharpeiSection != null) {
            orgSharpeiStaters = new StatersConfigBuilder(orgSharpeiSection).build();
        } else {
            orgSharpeiStaters = new StatersConfigBuilder(StatersConfigDefaults.INSTANCE).build();
        }

        if (orgSharpeiSection != null) {
            orgSharpeiConfig =
                new HttpHostConfigBuilder(orgSharpeiSection).build();
        } else {
            orgSharpeiConfig = new HttpHostConfigBuilder(sharpeiConfig).build();
        }
    }

    private static ImmutableHttpProxyConfig createConfig(final IniConfig ini)
        throws ConfigException
    {
        HttpProxyConfigBuilder config = new HttpProxyConfigBuilder(ini);
        config.name("MSAL");
        LoggerConfigBuilder loggerConfig =
            new LoggerConfigBuilder(BackendAccessLoggerConfigDefaults.INSTANCE);
        loggerConfig.single().logFormat(
            BackendAccessLoggerConfigDefaults.INSTANCE
                .logFormat()
                + ProxyAccessLoggerConfigDefaults.LOG_FORMAT_SUFFIX
                + " %{"
                + SearchProxyAccessLoggerConfigDefaults.HITS_COUNT
                + '}');
        config.loggers().accessLoggers(
            LoggersConfigBuilder.loadLoggers(
                ini.section(LoggersConfigBuilder.ACCESSLOG),
                new PatternMap<>(loggerConfig)));

        return config.build();
    }

    public ImmutableHttpHostConfig sharpeiConfig() {
        return sharpeiConfig;
    }

    public ImmutableHttpHostConfig orgSharpeiConfig() {
        return orgSharpeiConfig;
    }

    public ImmutablePoolConfig pgPoolConfig() {
        return pgPoolConfig;
    }

    public ImmutablePoolConfig aceVenturaPoolConfig() {
        return aceVenturaPoolConfig;
    }

    public ImmutableStatersConfig orgSharpeiStaters() {
        return orgSharpeiStaters;
    }
}

