package ru.yandex.search.msal;

import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionHolder implements AutoCloseable {
    private Connection connection;

    public ConnectionHolder(final Connection connection) {
        this.connection = connection;
    }

    public Connection get() {
        return connection;
    }

    public Connection release() {
        Connection connection = this.connection;
        this.connection = null;
        return connection;
    }

    @Override
    public void close() throws SQLException {
        if (connection != null) {
            connection.close();
            connection = null;
        }
    }
}

