package ru.yandex.search.msal;

import java.io.IOException;
import java.sql.SQLException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.server.sync.HttpSession;

public class DatabaseHandlerAdapter implements HttpRequestHandler {
    private final Server server;
    private final DatabaseHandler handler;

    public DatabaseHandlerAdapter(
        final Server server,
        final DatabaseHandler handler)
    {
        this.server = server;
        this.handler = handler;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException, IOException
    {
        HttpSession session = new HttpSession(request, response, context);
        try {
            server.handle(session, handler);
        } catch (SQLException e) {
            server.handleException(e, session.logger());
        }
    }

    @Override
    public String toString() {
        return handler.toString();
    }
}

