package ru.yandex.search.msal;

import org.apache.http.HttpRequest;

import ru.yandex.http.server.sync.HttpSession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.uri.CgiParams;

public class DumpParams {
    private final HttpSession session;
    private final JsonType jsonType;

    public DumpParams(final HttpSession session) throws BadRequestException {
        this.session = session;
        jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
    }

    public HttpSession session() {
        return session;
    }

    public HttpRequest request() {
        return session.request();
    }

    public CgiParams params() {
        return session.params();
    }

    public JsonType jsonType() {
        return jsonType;
    }

    public String mdb() throws BadRequestException {
        return session.params().get("mdb", NonEmptyValidator.INSTANCE);
    }

    public long suid() throws BadRequestException {
        return session.params().getLong("suid");
    }
}

