package ru.yandex.search.msal;

import org.apache.http.HttpEntityEnclosingRequest;

import ru.yandex.http.server.sync.HttpSession;
import ru.yandex.http.util.BadRequestException;

public class EntityDumpParams extends DumpParams {
    private final HttpEntityEnclosingRequest request;
    private final int batchSize;

    public EntityDumpParams(
        final HttpSession session,
        final HttpEntityEnclosingRequest request,
        final int defaultBatchSize)
        throws BadRequestException
    {
        super(session);
        this.request = request;
        batchSize = params().getInt("batch-size", defaultBatchSize);
    }

    @Override
    public HttpEntityEnclosingRequest request() {
        return request;
    }

    public int batchSize() {
        return batchSize;
    }
}
