package ru.yandex.search.msal;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

import ru.yandex.http.server.sync.HttpSession;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.search.msal.pool.DBConnectionPool;

public class GetFirstlineHandler extends AbstractReplicaHandler {
    public GetFirstlineHandler() {
        super(true);
    }

    @Override
    public void handlePgRequest(
        final HttpSession session,
        final DBConnectionPool connPool,
        final long uid)
        throws HttpException, SQLException
    {
        BigDecimal mid = new BigDecimal(session.params().getBigInteger("mid"));
        try (Connection connection = connPool.getConnection(session.logger());
            PreparedStatement stmt = connection.prepareStatement(
                "select firstline from mail.messages"
                + " where mid = ? and uid = ?"))
        {
            stmt.setBigDecimal(1, mid);
            stmt.setLong(2, uid);
            try (ResultSet resultSet = stmt.executeQuery()) {
                if (resultSet.next()) {
                    String firstline = resultSet.getString(1);
                    if (firstline != null) {
                        session.response().setEntity(
                            new StringEntity(
                                firstline,
                                ContentType.TEXT_PLAIN.withCharset(
                                    CharsetUtils.acceptedCharset(
                                        session.request()))));
                    }
                } else {
                    session.response().setStatusCode(HttpStatus.SC_NOT_FOUND);
                }
            }
        }
    }

    @Override
    public String toString() {
        return "Retrieves firstline by mid";
    }
}

