package ru.yandex.search.msal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.http.HttpException;
import org.apache.http.entity.StringEntity;

import ru.yandex.http.server.sync.HttpSession;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.NotFoundException;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.search.msal.pool.DBConnectionPool;

public class GetMidByMessageIdHandler extends AbstractMasterHandler {
    public GetMidByMessageIdHandler() {
        super(true);
    }

    @Override
    public void handlePgRequest(
        final HttpSession session,
        final DBConnectionPool connPool,
        final long uid)
        throws HttpException, SQLException
    {
        try (Connection connection = connPool.getConnection(session.logger());
            PreparedStatement stmt = connection.prepareStatement(
                "select mid from mail.messages where uid = ?"
                + " and hdr_message_id = ?"))
        {
            stmt.setLong(1, uid);
            stmt.setString(
                2,
                session.params().get(
                    "message-id",
                    NonEmptyValidator.INSTANCE));
            try (ResultSet resultSet = stmt.executeQuery()) {
                if (resultSet.next()) {
                    session.response().setEntity(
                        new StringEntity(
                            resultSet.getString(1),
                            CharsetUtils.acceptedCharset(session.request())));
                } else {
                    throw new NotFoundException();
                }
            }
        }
    }

    @Override
    public String toString() {
        return "Retrieves mid by user and message id";
    }
}

