package ru.yandex.search.msal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.http.HttpException;
import org.apache.http.entity.StringEntity;

import ru.yandex.http.server.sync.HttpSession;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.NotFoundException;
import ru.yandex.search.msal.pool.DBConnectionPool;

public class GetUserRevisionHandler extends AbstractReplicaHandler {
    public GetUserRevisionHandler() {
        super(true);
    }

    @Override
    public void handlePgRequest(
        final HttpSession session,
        final DBConnectionPool connPool,
        final long uid)
        throws HttpException, SQLException
    {
        try (Connection connection = connPool.getConnection(session.logger());
            PreparedStatement stmt = connection.prepareStatement(
                "select next_revision - 1 from mail.serials where uid = ?"))
        {
            stmt.setLong(1, uid);
            try (ResultSet resultSet = stmt.executeQuery()) {
                if (resultSet.next()) {
                    session.response().setEntity(
                        new StringEntity(
                            resultSet.getString(1),
                            CharsetUtils.acceptedCharset(session.request())));
                } else {
                    throw new NotFoundException();
                }
            }
        }
    }

    @Override
    public String toString() {
        return "Retrieves user revision";
    }
}

