package ru.yandex.search.msal;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.server.sync.HttpSession;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.EmptyFutureCallback;
import ru.yandex.http.util.HttpExceptionConverter;
import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.http.util.nio.client.BasicRequestsListener;
import ru.yandex.http.util.nio.client.RequestsListener;
import ru.yandex.http.util.server.LoggingServerConnection;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.sharpei.ConnInfo;
import ru.yandex.search.sharpei.SharpeiMode;

public class GetUserShardHandler implements HttpRequestHandler {
    private final Server server;

    public GetUserShardHandler(Server server) {
        this.server = server;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException, IOException
    {
        HttpSession session = new HttpSession(request, response, context);
        RequestsListener listener = new BasicRequestsListener();
        session.context().getConnection(LoggingServerConnection.class).setUpstreamStats(listener);
        CgiParams params = session.params();
        Long orgId = params.getLong("orgId", null);
        Long uid = null;
        if (orgId == null) {
            uid = params.getLong("uid");
        }

        ConnInfo connInfo;
        Charset charset;
        try {
            charset = CharsetUtils.acceptedCharset(request);

            if (orgId != null) {
                session.logger().info("Using org sharpei client");
                connInfo = server.orgSharpeiClient().orgInfo(
                    orgId,
                    SharpeiMode.READ_WRITE,
                    listener.createContextGeneratorFor(server.orgSharpeiClient()),
                    EmptyFutureCallback.INSTANCE)
                    .get();
            } else {
                connInfo = server.sharpeiClient().connInfo(
                    uid,
                    SharpeiMode.READ_WRITE,
                    listener.createContextGeneratorFor(server.sharpeiClient()),
                    EmptyFutureCallback.INSTANCE)
                    .get();
            }
        } catch (ExecutionException e) {
            throw HttpExceptionConverter.toHttpException(e.getCause());
        } catch (InterruptedException e) {
            throw new ServiceUnavailableException(e);
        }

        session.response().setEntity(new StringEntity(connInfo.shardId(), charset));
    }
}
