package ru.yandex.search.msal;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ExecutionException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.server.sync.HttpSession;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.EmptyFutureCallback;
import ru.yandex.http.util.HttpExceptionConverter;
import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.http.util.nio.client.BasicRequestsListener;
import ru.yandex.http.util.nio.client.RequestsListener;
import ru.yandex.http.util.server.LoggingServerConnection;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.sharpei.SharpeiClient;

public class ListShardsHandler implements HttpRequestHandler {
    private final SharpeiClient sharpeiClient;

    public ListShardsHandler(final Server server) {
        this.sharpeiClient = server.sharpeiClient();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException, IOException
    {
        RequestsListener listener = new BasicRequestsListener();
        HttpSession session = new HttpSession(request, response, context);

        session.context().getConnection(LoggingServerConnection.class)
            .setUpstreamStats(listener);
        CgiParams params = new CgiParams(request);

        JsonType jsonType = JsonTypeExtractor.NORMAL.extract(params);

        try {
            List<String> shardsInfo = sharpeiClient.shardsIds(
                listener.createContextGeneratorFor(sharpeiClient),
                EmptyFutureCallback.INSTANCE)
                .get();

            StringBuilderWriter sbw = new StringBuilderWriter();
            try (JsonWriter jw = jsonType.create(sbw)) {
                jw.value(shardsInfo);
            }

            Charset charset = CharsetUtils.acceptedCharset(request);
            session.response().setEntity(
                new StringEntity(
                    sbw.toString(),
                    charset));
        } catch (ExecutionException e) {
            throw HttpExceptionConverter.toHttpException(e.getCause());
        } catch (InterruptedException e) {
            throw new ServiceUnavailableException(e);
        }
    }
}
