package ru.yandex.search.msal;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MidsReader implements Closeable {
    private final List<String> mids = new ArrayList<>();
    private final BufferedReader reader;
    private final int batchSize;

    public MidsReader(final BufferedReader reader, final int batchSize) {
        this.reader = reader;
        this.batchSize = batchSize;
    }

    @Override
    public void close() throws IOException {
        reader.close();
    }

    public Object[] nextBatch() throws IOException {
        mids.clear();
        for (int i = 0; i < batchSize; ++i) {
            String mid = reader.readLine();
            if (mid == null) {
                break;
            }
            mids.add(mid.trim());
        }
        return mids.toArray();
    }
}

