package ru.yandex.search.msal;

import java.sql.ResultSet;
import java.sql.SQLException;

public class ResultSetHolder implements AutoCloseable {
    private ResultSet connection;

    public ResultSetHolder(final ResultSet connection) {
        this.connection = connection;
    }

    public ResultSet get() {
        return connection;
    }

    public ResultSet release() {
        ResultSet connection = this.connection;
        this.connection = null;
        return connection;
    }

    @Override
    public void close() throws SQLException {
        if (connection != null) {
            connection.close();
            connection = null;
        }
    }
}

