package ru.yandex.search.msal;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.server.sync.HttpSession;
import ru.yandex.search.msal.pool.DBConnectionPool;

public class ScopeOperationQueueHandler extends AbstractReplicaHandler {
    private final Map<MsalScope, AbstractOperationsQueueHandler> handlers;

    public ScopeOperationQueueHandler() {
        super(false);

        Map<MsalScope, AbstractOperationsQueueHandler> handlers
            = new LinkedHashMap<>();
        handlers.put(MsalScope.MAIL, new MailOperationsQueueHandler());
        handlers.put(MsalScope.CONTACTS, new ContactsOperationsQueueHandler());
        this.handlers = Collections.unmodifiableMap(handlers);
    }

    @Override
    public void handlePgRequest(
        final HttpSession session,
        final DBConnectionPool connPool,
        final long uid)
        throws HttpException, IOException, SQLException
    {
        MsalScope scope =
            session.params().getEnum(MsalScope.class, "scope", MsalScope.MAIL);
        handlers.get(scope).handlePgRequest(session, connPool, uid);
    }
}
