package ru.yandex.search.msal;

import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.http.HttpException;
import org.apache.http.entity.ContentType;

import ru.yandex.http.server.sync.CloseableEntityTemplate;
import ru.yandex.http.server.sync.ContentProducerWriter;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.search.msal.pool.StatementHolder;
import ru.yandex.search.msal.processors.ResultSetFieldProcessorFactory;
import ru.yandex.search.msal.writers.ResultSetProducer;

public final class SearchQueueHandler {
    private SearchQueueHandler() {
    }

    //CSOFF: ParameterNumber
    public static void writeResultSet(
        final DumpParams params,
        final ConnectionHolder conn,
        final StatementHolder<? extends PreparedStatement> stmt,
        final ResultSetFieldProcessorFactory processorFactory)
        throws SQLException, HttpException
    {
        try (ResultSetHolder resultSet =
                new ResultSetHolder(stmt.get().executeQuery()))
        {
            AutoCloseableCleaner<ResultSet> cleaner =
                new AutoCloseableCleaner<ResultSet>(resultSet.get(),
                    new AutoCloseableCleaner<PreparedStatement>(stmt.get(),
                        new AutoCloseableCleaner<Connection>(conn.get())));
            Charset charset = CharsetUtils.acceptedCharset(params.request());
            CloseableEntityTemplate entity =
                new CloseableEntityTemplate(
                    new ContentProducerWriter(
                        new ResultSetProducer(
                            cleaner,
                            params,
                            processorFactory),
                        charset),
                    cleaner);
            entity.setChunked(true);
            ContentType contentType;
            if (params.jsonType() == null) {
                contentType = ContentType.TEXT_PLAIN;
            } else {
                contentType = ContentType.APPLICATION_JSON;
            }
            entity.setContentType(contentType.withCharset(charset).toString());
            params.session().response().setEntity(entity);
            resultSet.release();
            stmt.release();
            conn.release();
        }
    }
    //CSON: ParameterNumber
}

