package ru.yandex.search.msal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.http.HttpException;

import ru.yandex.http.server.sync.HttpSession;
import ru.yandex.search.msal.pool.DBConnectionPool;

public class SetFirstlineHandler extends AbstractMasterHandler {
    public SetFirstlineHandler() {
        super(true);
    }

    @Override
    public void handlePgRequest(
        final HttpSession session,
        final DBConnectionPool connPool,
        final long uid)
        throws HttpException, SQLException
    {
        String firstline = session.params().getString("firstline");
        long mid = session.params().getLong("mid");
        try (Connection connection = connPool.getConnection(session.logger());
            PreparedStatement stmt = connection.prepareStatement(
                "update mail.messages set firstline = ? where mid = ? and "
                + "uid = ?"))
        {
            stmt.setString(1, firstline);
            stmt.setLong(2, mid);
            stmt.setLong(2 + 1, uid);
            stmt.execute();
        }
    }

    @Override
    public String toString() {
        return "Updates message firstline";
    }
}

