package ru.yandex.search.msal;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.http.HttpException;

import ru.yandex.http.server.sync.HttpSession;
import ru.yandex.search.msal.pool.DBConnectionPool;
import ru.yandex.search.msal.pool.StatementHolder;
import ru.yandex.search.msal.processors.ResultSetFieldProcessorFactory;

public class UserMidsHandler extends AbstractReplicaHandler {
    public UserMidsHandler() {
        super(true);
    }

    @Override
    public void handlePgRequest(
        final HttpSession session,
        final DBConnectionPool connPool,
        final long uid)
        throws HttpException, SQLException
    {
        DumpParams params = new DumpParams(session);
        try (ConnectionHolder conn = new ConnectionHolder(
                connPool.getConnection(params.session().logger()));
            StatementHolder<PreparedStatement> stmt =
                new StatementHolder<>(
                    conn.get().prepareStatement(
                        "select mid from mail.box where uid = ? "
                        + "order by mid")))
        {
            stmt.get().setLong(1, uid);
            SearchQueueHandler.writeResultSet(
                params,
                conn,
                stmt,
                ResultSetFieldProcessorFactory.INSTANCE);
        }
    }

    @Override
    public String toString() {
        return "Retrives all user mids from database";
    }
}

