package ru.yandex.search.msal.contacts;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.CodingErrorAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.http.HttpException;

import ru.yandex.dbfields.CollieFields;
import ru.yandex.http.server.sync.HttpSession;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.http.util.nio.NByteArrayEntityFactory;
import ru.yandex.io.DecodableByteArrayOutputStream;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.search.msal.AbstractReplicaHandler;
import ru.yandex.search.msal.pool.DBConnectionPool;

public class GetSharedByClientHandler extends AbstractReplicaHandler {
    private static final String SELECT_STMT =
        "select list_id, owner_user_id, owner_user_type, revision, owner_list_id from "
            + " contacts.subscribed_lists where user_id = ? "
            + "and user_type = ?::contacts.user_type "
            + "and owner_user_id = ? and owner_user_type = ?::contacts.user_type";

    private static final String SELECT_ALL_STMT =
        "select list_id, owner_user_id, owner_user_type, revision, owner_list_id from "
            + " contacts.subscribed_lists where user_id = ? "
            + "and user_type = ?::contacts.user_type";

    public GetSharedByClientHandler() {
        super(true);
    }

    // CSOFF: MagicNumber
    @Override
    public void handlePgRequest(
        final HttpSession session,
        final DBConnectionPool connPool,
        final long uid)
        throws HttpException, IOException, SQLException
    {
        String userType = session.params().getString("userType");
        Long ownerId = session.params().getLong("ownerId", null);
        String ownerUserType = session.params().getString("ownerUserType", null);
        if (ownerId != null && ownerUserType != null) {
            try (Connection connection =
                     connPool.getConnection(session.logger());
                 PreparedStatement stmt =
                     connection.prepareStatement(SELECT_STMT))
            {
                stmt.setLong(1, uid);
                stmt.setObject(2, userType);
                stmt.setLong(3, ownerId);
                stmt.setObject(4, ownerUserType);

                try (ResultSet resultSet = stmt.executeQuery()) {
                    writeResults(resultSet, session);
                }
            }
        } else {
            try (Connection connection =
                     connPool.getConnection(session.logger());
                 PreparedStatement stmt =
                     connection.prepareStatement(SELECT_ALL_STMT))
            {
                stmt.setLong(1, uid);
                stmt.setObject(2, userType);

                try (ResultSet resultSet = stmt.executeQuery()) {
                    writeResults(resultSet, session);
                }
            }
        }
    }
    // CSON: MagicNumber

    protected void writeResults(
        final ResultSet resultSet,
        final HttpSession session)
        throws HttpException, IOException, SQLException
    {
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        JsonType type = JsonTypeExtractor.DOLLAR.extract(session.params());

        try (OutputStreamWriter outWriter =
                 new OutputStreamWriter(
                     out,
                     CharsetUtils.acceptedCharset(session.request())
                         .newEncoder()
                         .onMalformedInput(
                             CodingErrorAction.REPLACE)
                         .onUnmappableCharacter(
                             CodingErrorAction.REPLACE));
             JsonWriter writer = type.create(outWriter))
        {
            writer.startArray();
            while (resultSet.next()) {
                writer.startObject();
                writer.key(CollieFields.LIST_ID);
                writer.value(resultSet.getLong(CollieFields.LIST_ID));
                writer.key(CollieFields.OWNER_USER_UID);
                writer.value(resultSet.getString(CollieFields.OWNER_USER_UID));
                writer.key(CollieFields.OWNER_USER_TYPE);
                writer.value(resultSet.getString(CollieFields.OWNER_USER_TYPE));
                writer.key(CollieFields.OWNER_LIST_ID);
                writer.value(resultSet.getString(CollieFields.OWNER_LIST_ID));
                writer.key(CollieFields.REVISION);
                writer.value(resultSet.getLong(CollieFields.REVISION));
                writer.endObject();
            }
            writer.endArray();
        }

        session.response().setEntity(
            NByteArrayEntityFactory.INSTANCE.process(
                out.toByteArray()));
    }
}
