package ru.yandex.search.msal.processors;

import java.io.IOException;
import java.sql.ResultSet;

import ru.yandex.search.msal.writers.ResultSetWriter;

public class ConstantFieldProcessor implements ResultSetFieldProcessor {
    private final String fieldName;
    private final String fieldValue;

    public ConstantFieldProcessor(
        final String fieldName,
        final String fieldValue)
    {
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
    }

    @Override
    public void process(
        final ResultSet resultSet,
        final int columnIndex,
        final ResultSetWriter writer)
        throws IOException
    {
        writer.write(fieldName, fieldValue);
    }
}

