package ru.yandex.search.msal.processors;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

import ru.yandex.search.msal.writers.ResultSetWriter;

public class JsonFieldProcessor implements ResultSetFieldProcessor {
    private final String fieldName;

    public JsonFieldProcessor(final String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void process(
        final ResultSet resultSet,
        final int columnIndex,
        final ResultSetWriter writer)
        throws IOException, SQLException
    {
        writer.writeJson(fieldName, resultSet.getString(columnIndex));
    }
}

