package ru.yandex.search.msal.processors;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;

import ru.yandex.dbfields.DBFieldInfo;
import ru.yandex.dbfields.DBFieldsRegistry;
import ru.yandex.dbfields.FieldProcessorFactory;

public class ResultSetFieldProcessorFactory
    implements FieldProcessorFactory<ResultSetFieldProcessor>
{
    public static final ResultSetFieldProcessorFactory INSTANCE =
        new ResultSetFieldProcessorFactory();

    private final Map<String, String> commonFields;

    protected ResultSetFieldProcessorFactory() {
        this(Collections.emptyMap());
    }

    public ResultSetFieldProcessorFactory(
        final Map<String, String> commonFields)
    {
        this.commonFields = commonFields;
    }

    public ResultSetFieldProcessor[] createProcessors(
        final ResultSetMetaData metadata)
        throws SQLException
    {
        int columns = metadata.getColumnCount();
        ResultSetFieldProcessor[] processors =
            new ResultSetFieldProcessor[columns + 1 + commonFields.size()];
        int i = 1;
        for (; i <= columns; ++i) {
            String label = metadata.getColumnLabel(i);
            DBFieldInfo fieldInfo = DBFieldsRegistry.INSTANCE.get(label);
            if (fieldInfo == null) {
                throw new SQLException("Unknown field: " + label);
            }
            processors[i] = fieldInfo.fieldType().createProcessor(
                this,
                fieldInfo.fieldName());
        }
        for (Map.Entry<String, String> entry: commonFields.entrySet()) {
            String fieldName = entry.getKey();
            DBFieldInfo fieldInfo = DBFieldsRegistry.INSTANCE.get(fieldName);
            if (fieldInfo != null) {
                fieldName = fieldInfo.fieldName();
            }
            processors[i++] =
                new ConstantFieldProcessor(fieldName, entry.getValue());
        }
        return processors;
    }

    @Override
    public JsonFieldProcessor createJsonProcessor(final String outFieldName) {
        return new JsonFieldProcessor(outFieldName);
    }

    @Override
    public StringFieldProcessor createStringProcessor(
        final String outFieldName)
    {
        return new StringFieldProcessor(outFieldName);
    }

    @Override
    public TimestampFieldProcessor createTimestampProcessor(
        final String outFieldName)
    {
        return new TimestampFieldProcessor(outFieldName);
    }
}

