package ru.yandex.search.msal.processors;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

import ru.yandex.search.msal.writers.ResultSetWriter;

public class StringFieldProcessor implements ResultSetFieldProcessor {
    private final String fieldName;

    public StringFieldProcessor(final String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void process(
        final ResultSet resultSet,
        final int columnIndex,
        final ResultSetWriter writer)
        throws IOException, SQLException
    {
        writer.write(fieldName, resultSet.getString(columnIndex));
    }
}

