package ru.yandex.search.msal.writers;

import java.io.IOException;
import java.util.List;

import ru.yandex.json.dom.ValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonWriter;

public class JsonResultSetWriter implements ResultSetWriter {
    private final JsonWriter writer;

    public JsonResultSetWriter(final JsonWriter writer) {
        this.writer = writer;
    }

    @Override
    public void write(
        final String name,
        final String value)
        throws IOException
    {
        if (!(value == null || value.isEmpty())) {
            writer.key(name);
            writer.value(value);
        }
    }

    @Override
    public void write(
        final String name,
        final List<String> values)
        throws IOException
    {
        if (!values.isEmpty()) {
            writer.key(name);
            writer.startArray();
            for (String value: values) {
                writer.value(value);
            }
            writer.endArray();
        }
    }

    @Override
    public void writeJson(
        final String name,
        final String value)
        throws IOException
    {
        if (!(value == null || value.isEmpty())) {
            Object dom;
            try {
                dom = ValueContentHandler.parse(value);
            } catch (JsonException e) {
                throw new IOException(e);
            }
            if (dom != null) {
                writer.key(name);
                writer.value(dom);
            }
        }
    }

    @Override
    public void beginRow() throws IOException {
        writer.startObject();
    }

    @Override
    public void endRow() throws IOException {
        writer.endObject();
    }

    @Override
    public void beginResultSet() throws IOException {
        writer.startObject();
        writer.key("rows");
        writer.startArray();
    }

    @Override
    public void endResultSet() throws IOException {
        writer.endArray();
        writer.endObject();
    }
}

