package ru.yandex.search.msal.writers;

import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;

import ru.yandex.http.server.sync.ContentWriter;
import ru.yandex.search.msal.AutoCloseableCleaner;
import ru.yandex.search.msal.DumpParams;
import ru.yandex.search.msal.processors.ResultSetFieldProcessor;
import ru.yandex.search.msal.processors.ResultSetFieldProcessorFactory;

public class ResultSetProducer implements ContentWriter {
    private final AutoCloseableCleaner<ResultSet> cleaner;
    private final DumpParams params;
    private final ResultSetFieldProcessor[] processors;

    public ResultSetProducer(
        final AutoCloseableCleaner<ResultSet> cleaner,
        final DumpParams params,
        final ResultSetFieldProcessorFactory processorFactory)
        throws SQLException
    {
        this.cleaner = cleaner;
        this.params = params;
        processors =
            processorFactory.createProcessors(cleaner.value().getMetaData());
    }

    @Override
    public void writeTo(final Writer out) throws IOException {
        writeTo(new JsonResultSetWriter(params.jsonType().create(out)));
    }

    private void writeTo(final ResultSetWriter out) throws IOException {
        int rows = 0;
        try (AutoCloseableCleaner<ResultSet> cleaner = this.cleaner) {
            ResultSet resultSet = cleaner.value();
            out.beginResultSet();
            while (resultSet.next()) {
                out.beginRow();
                for (int i = 1; i < processors.length; ++i) {
                    processors[i].process(resultSet, i, out);
                }
                out.endRow();
                ++rows;
            }
            out.endResultSet();
        } catch (SQLException e) {
            throw new IOException(e);
        }
        params.session().conn().setHitsCount(Integer.toString(rows));
    }
}

