package ru.yandex.search.msal.mock;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;

public class MockPreparedStatement
    extends MockStatement
    implements PreparedStatement
{
    private static final char HOLDER = '?';
    private final MockStatement statement;
    private final String sql;

    private final Map<Integer, String> params = new LinkedHashMap<>();
    private ResultSet currentResultSet;

    // CSOFF: ParameterNumber
    public MockPreparedStatement(
        final StaticDatabase database,
        final String sql)
    {
        super(database);

        this.statement = new MockStatement(database);
        this.sql = sql;
    }

    private String adjustQuery(final String sql) throws SQLException {
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (int i = 0; i < sql.length(); i++) {
            if (sql.charAt(i) == HOLDER) {
                index += 1;
                String replacement = params.get(index);
                if (replacement != null) {
                    sb.append(replacement);
                } else {
                    sb.append(HOLDER);
                }
            } else {
                sb.append(sql.charAt(i));
            }
        }

        return sb.toString();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        currentResultSet = statement.executeQuery(adjustQuery(sql));
        return currentResultSet;
    }

    @Override
    public ResultSet executeQuery(final String sql) throws SQLException {
        currentResultSet = statement.executeQuery(adjustQuery(sql));
        return currentResultSet;
    }

    @Override
    public boolean execute() throws SQLException {
        currentResultSet = statement.executeQuery(sql);
        return true;
    }

    @Override
    public boolean execute(final String sql) throws SQLException {
        currentResultSet = statement.executeQuery(sql);
        return true;
    }

    @Override
    public boolean execute(final String sql, final int[] columnIndexes)
        throws SQLException
    {
        return execute(sql);
    }

    @Override
    public boolean execute(final String sql, final String[] columnNames)
        throws SQLException
    {
        return execute(sql);
    }

    @Override
    public boolean execute(final String sql, final int autoGeneratedKeys)
        throws SQLException
    {
        return execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return currentResultSet;
    }

    @Override
    public void setTimestamp(final int parameterIndex, final Timestamp x)
        throws SQLException
    {
    }

    @Override
    public void setTimestamp(
        final int parameterIndex,
        final Timestamp x,
        final Calendar cal)
        throws SQLException
    {
    }

    @Override
    public void setTime(final int parameterIndex, final Time x)
        throws SQLException
    {
    }

    @Override
    public void setTime(
        final int parameterIndex,
        final Time x,
        final Calendar cal)
        throws SQLException
    {
    }

    @Override
    public void setAsciiStream(
        final int parameterIndex,
        final InputStream x,
        final int length)
        throws SQLException
    {
    }

    @Override
    public void setAsciiStream(
        final int parameterIndex,
        final InputStream x,
        final long length)
        throws SQLException
    {
    }

    @Override
    public void setAsciiStream(final int parameterIndex, final InputStream x)
        throws SQLException
    {
    }

    @Override
    public void setBinaryStream(
        final int parameterIndex,
        final InputStream x,
        final int length)
        throws SQLException
    {
    }

    @Override
    public void setBinaryStream(
        final int parameterIndex,
        final InputStream x,
        final long length)
        throws SQLException
    {
    }

    @Override
    public void setBinaryStream(final int parameterIndex, final InputStream x)
        throws SQLException
    {
    }

    @Override
    public void setBlob(final int parameterIndex, final Blob x)
        throws SQLException
    {
    }

    @Override
    public void setBlob(
        final int parameterIndex,
        final InputStream inputStream,
        final long length) throws SQLException
    {
    }

    @Override
    public void setBlob(final int parameterIndex, final InputStream inputStream)
        throws SQLException
    {
    }

    @Override
    public void setCharacterStream(
        final int parameterIndex,
        final Reader reader,
        final int length) throws SQLException
    {
    }

    @Override
    public void setCharacterStream(
        final int parameterIndex,
        final Reader reader,
        final long length) throws SQLException
    {
    }

    @Override
    public void setCharacterStream(
        final int parameterIndex,
        final Reader reader)
        throws SQLException
    {
    }

    @Override
    public void setObject(
        final int parameterIndex,
        final Object x,
        final int targetSqlType)
        throws SQLException
    {
    }

    @Override
    public void setObject(final int parameterIndex, final Object x)
        throws SQLException
    {
    }

    @Override
    public void setObject(
        final int parameterIndex,
        final Object x,
        final int targetSqlType,
        final int scaleOrLength)
        throws SQLException
    {
    }

    @Override
    public void setClob(final int parameterIndex, final Clob x)
        throws SQLException
    {
    }

    @Override
    public void setClob(
        final int parameterIndex,
        final Reader reader,
        final long length)
        throws SQLException
    {
    }

    @Override
    public void setClob(final int parameterIndex, final Reader reader)
        throws SQLException
    {
    }

    @Override
    public void setDate(final int parameterIndex, final Date x)
        throws SQLException
    {
    }

    @Override
    public void setDate(
        final int parameterIndex,
        final Date x,
        final Calendar cal)
        throws SQLException
    {
    }

    @Override
    public void setNClob(final int parameterIndex, final NClob value)
        throws SQLException
    {
    }

    @Override
    public void setNClob(
        final int parameterIndex,
        final Reader reader,
        final long length)
        throws SQLException
    {
    }

    @Override
    public void setNClob(final int parameterIndex, final Reader reader)
        throws SQLException
    {
    }

    @Override
    public void setNCharacterStream(
        final int parameterIndex,
        final Reader value,
        final long length) throws SQLException
    {
    }

    @Override
    public void setNCharacterStream(
        final int parameterIndex,
        final Reader value)
        throws SQLException
    {
    }

    @Override
    public void setNull(final int parameterIndex, final int sqlType)
        throws SQLException
    {
    }

    @Override
    public void setNull(
        final int parameterIndex,
        final int sqlType,
        final String typeName)
        throws SQLException
    {
    }

    @Override
    public void setByte(final int parameterIndex, final byte x)
        throws SQLException
    {
        this.params.put(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setBytes(final int parameterIndex, final byte[] x)
        throws SQLException
    {
        this.params.put(parameterIndex, new String(x, StandardCharsets.UTF_8));
    }

    @Override
    public int executeUpdate() throws SQLException {
        return 0;
    }

    @Override
    public void setBoolean(final int parameterIndex, final boolean x)
        throws SQLException
    {
        this.params.put(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setShort(final int parameterIndex, final short x)
        throws SQLException
    {
        this.params.put(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setInt(final int parameterIndex, final int x)
        throws SQLException
    {
        this.params.put(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setLong(final int parameterIndex, final long x)
        throws SQLException
    {
        this.params.put(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setFloat(final int parameterIndex, final float x)
        throws SQLException
    {
        this.params.put(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setDouble(final int parameterIndex, final double x)
        throws SQLException
    {
        this.params.put(parameterIndex, String.valueOf(x));
    }

    @Override
    public void setBigDecimal(final int parameterIndex, final BigDecimal x)
        throws SQLException
    {
        this.params.put(parameterIndex, x.toPlainString());
    }

    @Override
    public void setString(final int parameterIndex, final String x)
        throws SQLException
    {
        this.params.put(parameterIndex, x);
    }

    @Deprecated
    @Override
    public void setUnicodeStream(
        final int parameterIndex,
        final InputStream x,
        final int length)
        throws SQLException
    {
    }

    @Override
    public void clearParameters() throws SQLException {
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void setRef(final int parameterIndex, final Ref x)
        throws SQLException
    {
    }

    @Override
    public void setArray(final int parameterIndex, final Array x)
        throws SQLException
    {
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setURL(final int parameterIndex, final URL x)
        throws SQLException
    {
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setRowId(final int parameterIndex, final RowId x)
        throws SQLException
    {
    }

    @Override
    public void setNString(final int parameterIndex, final String value)
        throws SQLException
    {
    }

    @Override
    public void setSQLXML(final int parameterIndex, final SQLXML xmlObject)
        throws SQLException
    {
    }
    // CSON: ParameterNumber
}
