package ru.yandex.search.msal.mock;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MockStatement implements Statement {
    private static final Pattern TABLENAME_PATTERN =
        Pattern.compile(".*from (\\S*)\\s?.*", Pattern.CASE_INSENSITIVE);

    protected final StaticDatabase database;

    public MockStatement(final StaticDatabase database) {
        this.database = database;
    }

    @Override
    public ResultSet executeQuery(final String sql) throws SQLException {
        // Try to interpret SQL as a SELECT on a table
        Matcher tableMatcher = TABLENAME_PATTERN.matcher(sql);
        if (tableMatcher.matches()) {
            String tableName = tableMatcher.group(1);
            StaticTable table = database.table(tableName);
            if (table == null) {
                throw new SQLException(
                    "Table not found " + sql + ' ' + database.url());
            }

            List<Map<String, String>> data = table.get(sql);

            if (data == null) {
                throw new SQLException(
                    "No items left for " + sql + ' ' + database.url() + " left: " + table.suppliers().keySet() + " " + table.toString());
            }

            return new MockResultSet(
                tableName,
                new MockResultSerMetaData(tableName, table.meta()),
                data);
        }

        throw new SQLException("Unknown table in " + sql);
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(final int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(final int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(final boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(final int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(final String name) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchDirection(final int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(final int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public void addBatch(final String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return new int[0];
    }

    @Override
    public Connection getConnection() throws SQLException {
        return null;
    }

    @Override
    public boolean getMoreResults(final int current) throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(final String sql) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(
        final String sql,
        final int autoGeneratedKeys)
        throws SQLException
    {
        return 0;
    }

    @Override
    public int executeUpdate(final String sql, final int[] columnIndexes)
        throws SQLException
    {
        return 0;
    }

    @Override
    public int executeUpdate(final String sql, final String[] columnNames)
        throws SQLException
    {
        return 0;
    }

    @Override
    public boolean execute(final String sql) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(final String sql, final int autoGeneratedKeys)
        throws SQLException
    {
        return false;
    }

    @Override
    public boolean execute(final String sql, final int[] columnIndexes)
        throws SQLException
    {
        return false;
    }

    @Override
    public boolean execute(final String sql, final String[] columnNames)
        throws SQLException
    {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(final boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(final Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(final Class<?> iface) throws SQLException {
        return false;
    }
}
