package ru.yandex.msearch.proxy;

import java.io.IOException;
import java.net.URISyntaxException;

import org.apache.http.HttpException;

import ru.yandex.client.tvm2.Tvm2TicketRenewalTask;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.parser.JsonException;
import ru.yandex.msearch.proxy.config.ImmutableAsyncHttpServerBaseConfig;
import ru.yandex.search.proxy.universal.UniversalSearchProxy;

public abstract class AsyncHttpServerBase
    <C extends ImmutableAsyncHttpServerBaseConfig>
    extends UniversalSearchProxy<C>
{
    protected final AsyncClient filterSearchClient;
    protected final AsyncClient foldersClient;
    protected final AsyncClient mopsClient;
    protected final AsyncClient furitaClient;
    protected final AsyncClient tupitaClient;
    protected final AsyncClient producerStoreClient;

    protected final Tvm2TicketRenewalTask filterSearchTvm2RenewalTask;

    public AsyncHttpServerBase(C config)
        throws IOException, JsonException, HttpException, URISyntaxException
    {
        super(config);
        filterSearchClient = client("FilterSearch", config.filterSearchConfig());
        foldersClient = client("FoldersClient", config.foldersConfig());
        if (config.mopsClientConfig() != null) {
            mopsClient = client("MopsClient", config.mopsClientConfig());
        } else {
            mopsClient = null;
        }
        furitaClient = client("FuritaClient", config.furitaConfig());
        tupitaClient = client("TupitaClient", config.tupitaConfig());

        filterSearchTvm2RenewalTask = new Tvm2TicketRenewalTask(
                logger().addPrefix("filterSearchTvm2"),
                serviceContextRenewalTask,
                config.filterSearchTvm2ClientConfig());

        if (config.producerStoreConfig() != null) {
            producerStoreClient = client("ProducerStore", config.producerStoreConfig());
        } else {
            producerStoreClient = null;
        }
    }

    public AsyncClient filterSearchClient() {
        return filterSearchClient;
    }

    public AsyncClient foldersClient() {
        return foldersClient;
    }

    public AsyncClient mopsClient() {
        return mopsClient;
    }

    public AsyncClient furitaClient() {
        return furitaClient;
    }

    public AsyncClient tupitaClient() {
        return tupitaClient;
    }

    public String filterSearchTvm2Ticket() {
        return filterSearchTvm2RenewalTask.ticket();
    }

    public AsyncClient producerStoreClient() {
        return producerStoreClient;
    }

    @Override
    public void start() throws IOException {
        filterSearchTvm2RenewalTask.start();
        super.start();
    }

    @Override
    public void close() throws IOException {
        filterSearchTvm2RenewalTask.cancel();
        super.close();
    }
}
