package ru.yandex.msearch.proxy;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public enum MsearchProxyExperiment {
    PS3164(110981),
    PS3163(110977),
    PS3137(110975),
    PS3135(110972),
    PS3134(110843),
    PS3133(110838),
    ;

    private final int testId;

    MsearchProxyExperiment(final int testId) {
        this.testId = testId;
    }

    public int testId() {
        return testId;
    }

    public static final Map<String, MsearchProxyExperiment> EXPERIMENTS;

    static {
        Map<String, MsearchProxyExperiment> experimentMap
            = new LinkedHashMap<>();

        for (MsearchProxyExperiment e: MsearchProxyExperiment.values()) {
            experimentMap.put(String.valueOf(e.testId()), e);
        }

        EXPERIMENTS = Collections.unmodifiableMap(experimentMap);
    }

    public static MsearchProxyExperiment find(final String expId) {
        return EXPERIMENTS.get(expId);
    }
}
