package ru.yandex.msearch.proxy;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.Map;
import java.util.Arrays;
import java.io.PrintStream;
import java.io.OutputStreamWriter;
import java.io.IOException;
import org.json.JSONWriter;

import ru.yandex.msearch.proxy.logger.Logger;
import ru.yandex.msearch.proxy.document.Document;
import ru.yandex.msearch.proxy.collector.Collector;
import ru.yandex.msearch.proxy.HttpServer.HttpParams;

public class OutputPrinter
{
HttpParams params;
String sessionId;
PrintStream ps;

    public OutputPrinter( String sessionId, HttpParams params, PrintStream ps )
    {
	this.sessionId = sessionId;
	this.params = params;
	this.ps = ps;
    }
    
    public int print( Collector collector )
    {
	String format = params.get("format");
	if( format == null ) format = "text";
	int offset = 0;
	int length = 9999999;
	if( params.get("offset") != null ) offset = Integer.parseInt( params.get("offset") );
	if( params.get("length") != null ) length = Integer.parseInt( params.get("length") );
	
	String nearField = null;
	String nearValue = null;
	boolean returnEmptySet = false;

	Map<Document,Document> hits = collector.hits();
	Iterator<Document> iter = hits.keySet().iterator();

	if( params.get("near") != null )
	{
//	    String near = URLDecoder.decode( ((String)params.get("near")), "utf8" );
	    String near = params.get("near");
	    int sep = near.indexOf( ':' );
	    if( sep != -1 )
	    {
		nearField = near.substring( 0, sep );
		nearValue = near.substring( sep + 1 );
		if( !Arrays.asList(getGetFields()).contains(nearField) )
		{
		    nearField = null;
		    nearValue = null;
		} 
		else
		{
		    int needlePos = 0;
		    boolean found = false;
		    while( iter.hasNext() )
		    {
			Document doc = iter.next();
			String val = doc.getAttr(nearField);
			if( val != null && val.equals(nearValue) )
			{
			    found = true;
			    break;
			}
			needlePos++;
		    }
		    if( !found )
		    {
			returnEmptySet = true;
			Logger.warn( "Near not found: " + nearField + ":" + nearValue );
		    }
		    offset = needlePos + offset;
		    iter = hits.keySet().iterator();
		}
	    }
	}
	
	if( format.equals("text") )
	{
	    return printText( iter, offset, length, returnEmptySet ? 0 : collector.getTotalCount() );
//	    printText( iter, offset, length, returnEmptySet ? 0 : hits.size() );
	}
	else
	{
	    return printJSON( iter, offset, length, returnEmptySet ? 0 : collector.getTotalCount() );
//	    printJSON( iter, offset, length, returnEmptySet ? 0 : hits.size() );
	}
	
	
	
    }
    
    private int printText( Iterator<Document> iter, int offset, int length, int total )
    {
	ps.print("Ok\n" + total + "\n0\n" );
	int count = 0;
	int pos = 0;
	while( iter.hasNext() )
	{
	    Document doc = iter.next();
	    if( pos++ < offset ) continue;
	    if( pos > offset + length ) break;
	    String mid = doc.getAttr("mid");
	    String date = doc.getAttr("received_date");
	    ps.println( mid + " " + date + "/0 0 0" );
	    count++;
	}
	return count;
    }
    
    private String[] getGetFields()
    {
	String gf = params.get("getfields");
	if( gf == null || gf.length() == 0 ) gf = "mid";
	String[] fields = gf.split(",");
	return fields;
    }
    
    private int printJSON( Iterator<Document> iter, int offset, int length, int total )
    {
//	ps.print("Ok\n" + collector.getTotalCount() + "\n0\n" );
//	printText( collector );
	int count = 0;
        try
        {
    	    boolean human = false;
    	    if( params.count( "human" ) > 0 ) human = true;
    	    int pos = 0;
	    OutputStreamWriter writer = new OutputStreamWriter(ps);
	    JSONWriter jw = new JSONWriter( writer );
	    jw.object();
	    jw.key( "hitsCount" );
	    jw.value( total );

	    jw.key( "hitsArray" );
	    jw.array();
	    if( human ) writer.write( '\n' );

	        String[] getFields = getGetFields();
	        while( iter.hasNext() && total-- > 0 )
		{
		    Document doc = iter.next();
		    if( pos++ < offset ) continue;
		    if( pos > offset + length ) break;
		    try
		    {
		        formJSONObject( doc, jw, getFields );
			if( human ) writer.write( '\n' );
//		    ps.println( yadoc.get("mid") + " " + yadoc.get("mid") + "/" + yadoc.get("hid") + " 0 0" );
		    } catch( Exception e )
		    {
		        e.printStackTrace();
	    	    }
	    	    count++;
		}
	    jw.endArray();
	    jw.endObject();
	    writer.flush();
//	    writer.close();
	}
	catch( org.json.JSONException e )
	{
	    e.printStackTrace();
	}
	catch( java.io.IOException ie )
	{
	    ie.printStackTrace();
	}
	return count;
    }

    void formJSONObjectFields( Document doc, JSONWriter jw, String[] getFields ) throws IOException, org.json.JSONException {
	for( int f = 0; f < getFields.length; f++ )
	{
	    jw.key( getFields[f] );
	    String value = doc.getAttr(getFields[f]);
	    jw.value( value );
//	    jw.rawStringValue( value );
//	    jw.value( "#" + value.length() + "\"" + value );
	}
    }

    void formJSONObject( Document doc, JSONWriter jw, String[] getFields ) throws IOException, org.json.JSONException {
	jw.object();
	    formJSONObjectFields( doc, jw, getFields );
	    if( doc.getMergedCount() > 0 ) {
		jw.key("merged_docs");
		jw.array();
		for( int i = 0; i < doc.getMergedCount(); i++ ) {
		    jw.object();
		    formJSONObjectFields( doc.getMerged(i), jw, getFields );
		    jw.endObject();
		}
		jw.endArray();
	    }
	jw.endObject();
    
    }

}

