package ru.yandex.msearch.proxy;

import java.util.logging.Logger;

import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.server.async.BaseAsyncServer;

public class SyncCodeHandler implements HttpAsyncRequestHandler<HttpRequest> {
    private final HttpWorkerPool pool;
    private final AsyncHttpServer server;

    public SyncCodeHandler(
        final HttpWorkerPool pool,
        final AsyncHttpServer server)
    {
        this.pool = pool;
        this.server = server;
    }

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
    {
	HttpWorkerPool.HttpWork work =
	    new HttpWorkerPool.HttpWork(request, exchange, context, server);
	if (!pool.offer(work)) {
	    String msg = "Sync HttpServer work queue is full. " +
	        "Dropping connection";
            ((Logger) context.getAttribute(BaseAsyncServer.LOGGER))
                .severe(msg);
	    work.fail(msg, HttpStatus.SC_SERVICE_UNAVAILABLE);
        }
    }
}
