package ru.yandex.msearch.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.HttpAsyncContentProducer;

import ru.yandex.msearch.proxy.HttpServer.RequestContext;

public class SyncCodeHttpEntity
    extends AbstractHttpEntity
    implements HttpAsyncContentProducer
{
    private final HttpServer.RequestContext ctx;
    private final boolean isChunked;

    public SyncCodeHttpEntity(
        final HttpServer.RequestContext ctx,
        final boolean isChunked)
    {
        this.ctx = ctx;
        this.isChunked = isChunked;
    }

    @Override
    public void produceContent(
        final ContentEncoder encoder,
        final IOControl ioctrl)
        throws IOException
    {
        if (ctx.getIOControl() == null) {
            ctx.setIOControl(ioctrl);
        }
        ctx.ps.writeContent(encoder);
    }

    @Override
    public boolean isChunked() {
        return isChunked;
    }

    @Override
    public boolean isStreaming() {
        return true;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public long getContentLength() {
        return -1;
    }


    @Override
    public void writeTo(OutputStream outstream) throws IOException {
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        return null;
    }

    @Override
    public void close() {
//        System.err.println("CLOSE: " + ctx.getIOControl());
        ctx.abort();
    }
}
